package org.msh.tb.bd.dashboard.query;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * Created by Mauricio on 23/05/2017.
 */
public class Indicator06Query extends IndicatorQuery {

    @Override
    public Float calculateRate(Object[] o) {
        Long female = (Long) o[1];
        Long male = (Long) o[2];

        if (female == null || female <= 0 || male == null || male <= 0) {
            return new Float(0);
        }

        BigDecimal bd = new BigDecimal((male * 1.0)/female).setScale(2, RoundingMode.HALF_EVEN);
        Float result = new Float(bd.floatValue());

        return result;
    }

    @Override
    protected List<Object[]> getQueryResult(String adminUnitCondition) {
        // query indicator result
        // get population by administrative units child of auSelected
        // get new and relapses cases notified inside each of these administrative units
        List<Object[]> result = getEntityManager().createQuery("select au.name.name1, " +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and p.gender = 1 " + // female
                    "and p.workspace.id = :wsId)," +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and p.gender = 0 " + // male
                    "and p.workspace.id = :wsId)" +
                "from AdministrativeUnit au " +
                "where au.workspace.id = :wsId " + adminUnitCondition +
                "order by au.name.name1")
                .setParameter("iniDate", getIniDate())
                .setParameter("endDate", getEndDate())
                .setParameter("wsId", getWorkspace().getId())
                .getResultList();

        return result;
    }
}
